package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.activity;

import cn.com.duiba.biz.tool.duiba.dto.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.MallActivityDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.base.BaseActivityVo;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.PrizeRecordReceiveDTO;

import java.util.List;

/**
 * @date:2022/3/24 11:50
 * @author:zhaozhanghai
 * @Description: 活动服务
 */
@AdvancedFeignClient
public interface RemoteActivityService {


    /**
     *
     *
     * @param request@return 活动id
     * @throws BizException
     */
    Long addActivityAndPrize(BaseActivityVo activityVo) throws BizException;


    /**
     * 修改活动和奖品
     *
     *
     *
     * @param activityVo@throws BizException
     * @return
     */
    Boolean updateActivityAndPrize(BaseActivityVo activityVo) throws BizException;

    MallActivityDTO getByActivityId(Long activityId);

    /**
     * 删除活动
     * @param activityId
     * @return
     */
    Boolean delete(Long activityId);

    /**
     * 更新活动状态
     * @param activityId
     * @param status
     * @return
     */
    Boolean updateStatus(Long activityId,Integer status);

    /**
     * 分页查询
     * @param page
     * @param dto
     * @return
     */
    Page<MallActivityDTO> page(Page page, MallActivityDTO dto);


    /**
     * 活动详情
     * @param activityId
     * @return
     * @throws BizException
     */
    BaseActivityVo detail(Long activityId) throws BizException;

    /**
     * 获取活动奖品领取信息
     * @param activityId
     * @return
     */
    List<PrizeRecordReceiveDTO> getActivityPrizeReceiveNum(Long activityId);

}
