package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.assist;

import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.dto.PlaywayAssistItemDTO;

import java.util.List;
import java.util.Map;

public interface AssistPlayWayApi{

//    /**
//     * 返回当前用户的助力context
//     *
//     * @return assist user context
//     */
//    AssistUserContext getMyAssistContext();

    /**
     * 返回指定用户的助力context
     *
     * @return assist user context
     */
    AssistUserContext getAssistContext();

    /**
     * 返回指定助力物品的context
     *
     * @param assistItemId assist item id
     * @return assist item context
     */
    AssistItemContext getAssistItemContext(Long assistItemId);

    /**
     * 返回指定助力物品
     *
     * @param assistItemId assist item id
     * @return assist item
     */
    PlaywayAssistItemDTO find(Long activityId, String playwayId, Long assistItemId);

    /**
     * 发起一个助力
     *
     * @param item 助力物品 玩法内需要唯一
     * @return assist item id
     */
    Long createAssistItem(Long activityId, String playwayId, Long cid, String item);

    /**
     * 更新助力物品的启用/停用状态
     *
     * @param enable 1 启动 0 停用
     */
    boolean updateAssistItemStatus(Long activityId, String playwayId, Long assistItemId, boolean enable);

    /**
     * 将此次助力落库
     *
     * @param assistItemId assist item id
     * @return assist record id
     */
    Long doAssist(Long activityId, String playwayId, Long cid, Long assistItemId);

    /**
     * 生成助力，并记录extra信息
     *
     * @param assistItemId assist item id
     * @param extra        extra info
     * @return assist record id
     */
    Long doAssist(Long activityId, String playwayId, Long cid, Long assistItemId, String extra);

    /**
     * 批量查询用户创建的助力物品清单
     *
     * @param userIds user id list
     * @return map
     */
    Map<Long, List<PlaywayAssistItemDTO>> batchQueryUserAssistItems(Long activityId, String playwayId, List<String> userIds);

    /**
     * 分页查询 创建的所有助力物品清单
     * 根据创建时间倒排序查询
     * 从prePageMinId开始往下查询size个物品
     *
     * @param prePageMinId 上一页最小id
     * @param size         希望返回的个数
     * @return assist item list
     */
    List<PlaywayAssistItemDTO> queryMore(Long activityId, String playwayId, long prePageMinId, int size);

    /**
     * 工具方法，将参数中disable的item剔除
     *
     * @param list assist item list
     * @return assist item list without disable items
     */
    List<PlaywayAssistItemDTO> removeDisableItem(List<PlaywayAssistItemDTO> list);

}
