package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.assist;


import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.dto.PlaywayAssistItemDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.dto.PlaywayAssistRecordDTO;

import java.util.List;

public interface AssistUserContext {

    /**
     * 查询我今天的助力记录
     * 根据时间倒序排列
     * @return assist record list
     */
    List<PlaywayAssistRecordDTO> getTodayDoAssistList(Long activityId, String playwayId, Long cid);

    /**
     * 我的助力物品列表
     * @return assist item list
     */
    List<PlaywayAssistItemDTO> getAllAssistItemList(Long activityId, String playwayId, Long cid);

    /**
     * 查询我所有的助力记录
     * @return assist record list
     */
    List<PlaywayAssistRecordDTO> getAllDoAssistList(Long activityId, String playwayId, Long cid);

    /**
     * 今日助力总次数
     * @return count
     */
    int getTodayDoAssistCount(Long activityId, String playwayId, Long cid);
}
