package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author sunyan
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TbTicketRecordDTO implements Serializable {
    public static final Integer PROCESSING = 0;
    public static final Integer SUCCESS = 1;
    public static final Integer FAIL = 2;
    private static final long serialVersionUID = -8900957561498893946L;

    private Long id;
    /**
     * 门票唯一标识码 32位UUID
     */
    private String ticketNum;
    /**
     * 活动ID
     */
    private String activityId;
    /**
     * 玩法ID
     */
    private String playwayId;
    /**
     * 用户ID
     */
    private String userId;
    /**
     * 门票面额
     */
    private Long quantity;
    /**
     * 领取状态  0:处理中，1:门票领取成功，2:领取失败
     */
    private Integer state;
    /**
     * 是否使用 true 已使用 false 未使用
     */
    private Boolean used;
    /**
     * 使用方记录Id
     */
    private Long useSideRecordId;
    /**
     * 第三方流水ID
     */
    private String bizId;
    /**
     * 扩展字段
     */
    private String extra;
    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 变更时间
     */
    private Date gmtModified;
}
