package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.dto.TbTicketRecordDTO;

import java.util.List;

/**
 * 积分票据服务
 * @author sunyan
 */
@AdvancedFeignClient
public interface RemoteTicketRecordService {
    /**
     * 查询记录
     *
     * @param ticketNum
     * @return
     */
    TbTicketRecordDTO find(String ticketNum);

    /**
     * 查询未使用的门票列表
     *
     * @param tbTicketRecordDTO
     * **/
    List<TbTicketRecordDTO> findUnusedTicketList(TbTicketRecordDTO tbTicketRecordDTO);

    /**
     * 添加记录
     *
     * @param tbTicketRecordDTO
     */
    void insert(TbTicketRecordDTO tbTicketRecordDTO);

    /**
     * 修改状态
     *
     * @param ticketNum
     * @param state
     */
    int updateStatus(String ticketNum, Integer state, String bizId, String extra);

    /**
     * 使用门票
     *
     * @return
     */
    int useTicket(String ticketNum, String activityId, String playwayId, String userId);

    /**
     * 查询第三方记录ID
     *
     * @param ticketNum
     * @return
     */
    String findBizId(String ticketNum);
}
