package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.scoring;

import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.enums.PlaywayEnum;
import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.annotation.Preinstall;
import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.AbstractPlayWay;
import org.springframework.beans.factory.annotation.Autowired;

@Preinstall
public abstract class AbstractScoringPlayWay extends AbstractPlayWay {

    @Autowired
    protected ScoringUserRequestApi scoringUserRequestApi;

    /**
     * 如允许开始游戏，请调用 startNow() 获得参与游戏的startId，并将startId返回给前端
     *
     * @return
     */
    public abstract Object start();

    /**
     * @param startId
     * @return Object
     */
    public abstract Object submit(Long startId, Integer score);


//    protected Long startNow(){
//        TbPlaywayActionRecord entity = new TbPlaywayActionRecord();
//        ActivityContext activityContext = ApiContext.getActivityContext();
//        entity.setActivityId(activityContext.getId());
//        entity.setPlaywayId(activityContext.getScene());
//        entity.setActionId("666");
//        entity.setUserId(activityContext.getCid());
//        entity.setPlaywayType(getPlayWay().getType());
//        actionRecordService.insertEntity(entity);
//        return entity.getId();
//    }

    @Override
    protected PlaywayEnum getPlayWay() {
        return PlaywayEnum.SCORING;
    }
}
