package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.MallActivityDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.MallActivitySimpleDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.base.BaseActivityVo;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.PrizeRecordReceiveDTO;
import cn.com.duiba.wolf.entity.PageRequest;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * @date:2022/3/24 11:50
 * @author:zhaozhanghai
 * @Description: 活动服务
 */
@AdvancedFeignClient
public interface RemoteActivityService {


    /**
     *
     *
     * @param activityVo
     * @return 活动id
     * @throws BizException
     */
    Long addActivityAndPrize(BaseActivityVo activityVo) throws BizException;


    /**
     * 修改活动和奖品
     *
     *
     *
     * @param activityVo@throws BizException
     * @return
     */
    Boolean updateActivityAndPrize(BaseActivityVo activityVo) throws BizException;

    MallActivityDTO getByActivityId(Long activityId);

    /**
     * 删除活动
     * @param activityId
     * @return
     */
    Boolean delete(Long activityId);

    /**
     * 更新活动状态
     * @param activityId
     * @param status
     * @return
     */
    Boolean updateStatus(Long activityId,Integer status);

    /**
     * 分页查询
     * @param page
     * @param dto
     * @return
     */
    PageResponse<MallActivityDTO> page(PageRequest page, MallActivityDTO dto);


    /**
     * 活动详情
     * @param activityId
     * @return
     * @throws BizException
     */
    BaseActivityVo detail(Long activityId) throws BizException;

    /**
     * 获取活动奖品领取信息
     * @param activityId
     * @return
     */
    List<PrizeRecordReceiveDTO> getActivityPrizeReceiveNum(Long activityId);

    /**
     * 获取活动基础信息列表
     * @param appId
     * @return
     */
    List<MallActivitySimpleDTO> listSimpleActivityByAppId(Long appId);

    /**
     * 获取活动列表
     * @param appId
     * @param status
     * @return
     */
    List<MallActivityDTO> listByStatus(Long appId,Integer status);

}
