package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.dto;


import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.Ranking;

import java.util.Date;

public class PlaywayRankingDTO implements Ranking {

    private Long id;

    private Long activityId;

    private String type;

    private Long userId;

    private Integer maxScore;

    private Long maxScoreOrder;

    private Boolean sendPrize;

    private String prizeId;

    private Date sendPrizeTime;

    private Date gmtCreate;

    private Date gmtModified;

    /**
     * 生成maxScoreOrder
     * @param high2low  true: 分数从高到低排名  false：分数从低到高排名
     */
    public void genMaxScoreOrder(boolean high2low){
        maxScoreOrder=genMaxScoreOrder(maxScore,high2low);
    }

    public static Long genMaxScoreOrder(Integer maxScore,boolean high2low){
        if(maxScore==null){
            throw new RuntimeException("maxScore不能为空");
        }
        //Long.MAX_VALUE = 9223372036854775807
        //前7位存储分数+后12位存储时间戳
        //前7位不能超过9223372,maxScore>=1,所以topScore-maxScore最大为9223371，最小为10000000
        //所以可以提交的分数最大为8223372
        int topScore=9223372;
        long topUpper=999999999999L;// length(System.currentTimeMillis())-1 =12 精确到0.01秒

        //Long.MAX_VALUE = 9223372036854775807
        //前11位存储分数+后8位存储时间戳
        // 最小 10000000000
        // 最大 92233720368
        // 可提交分数: 92233720368-10000000000 = 82233720368
        // 排行榜序列号：54775807

        Long maxScoreOrder=null;

        if(high2low){
            maxScoreOrder=new Long(maxScore.toString()+""+(topUpper-(System.currentTimeMillis()/10)));
        }else {
            maxScoreOrder=new Long((topScore-maxScore)+""+(topUpper-(System.currentTimeMillis()/10)));
        }
        return maxScoreOrder;
    }


    @Override
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    @Override
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Override
    public Integer getMaxScore() {
        return maxScore;
    }

    public void setMaxScore(Integer maxScore) {
        this.maxScore = maxScore;
    }

    public Long getMaxScoreOrder() {
        return maxScoreOrder;
    }

    public void setMaxScoreOrder(Long maxScoreOrder) {
        this.maxScoreOrder = maxScoreOrder;
    }

    @Override
    public Boolean getSendPrize() {
        return sendPrize;
    }

    public void setSendPrize(Boolean sendPrize) {
        this.sendPrize = sendPrize;
    }

    @Override
    public String getPrizeId() {
        return prizeId;
    }

    public void setPrizeId(String prizeId) {
        this.prizeId = prizeId;
    }

    @Override
    public Date getSendPrizeTime() {
        return sendPrizeTime;
    }

    public void setSendPrizeTime(Date sendPrizeTime) {
        this.sendPrizeTime = sendPrizeTime;
    }

    @Override
    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    @Override
    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
