package cn.com.duiba.cloud.duiba.activity.service.api.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @date:2022/3/25 14:24
 * @author:zhaozhanghai
 * @Description: 活动状态
 */
public enum PriceRecordStateEnum {

    WAIT_RECEIVE(1,"待领取"),
    RECEIVED(2,"已领取"),
    RECEIVE_FAIL(3,"失败"),
    RECEIVED_EXPIRE(4,"过期"),
    ;

    PriceRecordStateEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    private Integer status;
    private String desc;


    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

    public static PriceRecordStateEnum getByStatus(Integer status){
        PriceRecordStateEnum activityStatusEnum = Arrays.asList(PriceRecordStateEnum.values()).stream().filter(i -> Objects.equals(i.getStatus(), status)).findFirst().orElse(null);
        return activityStatusEnum;
    }
}
