package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.remote;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.dto.PlaywayActionRecordDTO;

import java.util.Date;
import java.util.List;

@AdvancedFeignClient
public interface RemoteActionRecordService {

    /**
     * 新增用户action记录
     */
    Long addRecord(PlaywayActionRecordDTO actionRecordDTO);

    /**
     * 查询用户参与次数
     *
     * @param activityId
     * @param userId
     * @param start
     * @param end
     * @return
     */
    Long countUserRecord(Long activityId, String playwayId, Long userId, Date start, Date end);

    /**
     * 查询我的参与记录
     *
     * @param activityId
     * @param playwayId
     * @param userId
     * @return
     */
    List<PlaywayActionRecordDTO> findActionRecord(Long activityId, String playwayId, Long userId, Date start, Date end);

    /**
     * 查询最近的参与记录
     * @param activityId
     * @param playwayId
     * @param userId
     * @param limit
     * @return
     */
    List<PlaywayActionRecordDTO> findRecentActionRecord(Long activityId, String playwayId, Long userId, int limit);

    PlaywayActionRecordDTO find(Long id);

    /**
     * 查询用户连续参与天数
     *
     * @param maxdays 最大查询天数
     * @return
     */
    int countMyContinueDays(Long activityId, String playwayId, Long userId, int maxdays);

    void updateExtra(Long id, String extra);

}
