/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.activity.service.api.utils;

import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.dto.ConsumerDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.mallapp.MallAppVipConfDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.mallapp.MallAppVipGradeDTO;
import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ConsumerVipLevelUtil {
    public static String getVipLevel(ConsumerDTO consumerDTO, String vipTypeName, List<MallAppVipConfDTO> vipConfDTOList) {
        MallAppVipConfDTO mallAppVipConfDTO = ConsumerVipLevelUtil.getVipType(vipTypeName, vipConfDTOList);
        String gradeDevTag = null == consumerDTO ? null : consumerDTO.getVipLevelByType(vipTypeName);
        return ConsumerVipLevelUtil.checkVipLevel(gradeDevTag, mallAppVipConfDTO);
    }

    private static MallAppVipConfDTO getVipType(String vipTypeName, List<MallAppVipConfDTO> vipConfDTOList) {
        if (CollectionUtils.isEmpty(vipConfDTOList)) {
            return null;
        }
        MallAppVipConfDTO mallAppVipConfDTO = StringUtils.isBlank((CharSequence)vipTypeName) || vipConfDTOList.stream().noneMatch(x -> vipTypeName.equals(x.getVipTypeName())) ? vipConfDTOList.get(0) : (MallAppVipConfDTO)vipConfDTOList.stream().filter(x -> vipTypeName.equals(x.getVipTypeName())).findFirst().orElse(null);
        return mallAppVipConfDTO;
    }

    private static String checkVipLevel(String gradeDevTag, MallAppVipConfDTO mallAppVipConfDTO) {
        if (null == mallAppVipConfDTO) {
            return gradeDevTag;
        }
        List gradeDTOList = JSON.parseArray((String)mallAppVipConfDTO.getVipLevelConfig(), MallAppVipGradeDTO.class);
        if (CollectionUtils.isEmpty((Collection)gradeDTOList)) {
            return gradeDevTag;
        }
        if (StringUtils.isBlank((CharSequence)gradeDevTag) || gradeDTOList.stream().noneMatch(x -> gradeDevTag.equals(x.getDevTag()))) {
            gradeDTOList.sort(Comparator.comparing(MallAppVipGradeDTO::getGrade));
            return ((MallAppVipGradeDTO)gradeDTOList.get(0)).getDevTag();
        }
        return gradeDevTag;
    }
}

