package cn.com.duiba.cloud.duiba.activity.service.api.param;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author zhengjianhao
 * @date 2022/4/14
 * @description 概率出奖入参
 */
@Data
public class StrategyBaseRequest implements Serializable {

	private static final long serialVersionUID = -1862543248355355056L;

	/**
	 * 活动id：必传
	 */
	private Long activityId;

	/**
	 * 发奖规则编码：必传
	 */
	private String ruleCode;

	/**
	 * 中奖用户id：必传
	 */
	private Long consumerId;

	/**
	 * 扣积分票据号：扣积分参与中奖时需要传
	 */
	private String ticketNum;

	/**
	 * 是否直接出奖：
	 *      是，发奖记录和订单状态为已领取，不需要用户去点击领取；
	 *      否，发奖记录和订单状态为待领取，需要用户手动点击领取
	 *  注：对于特定奖品（实物、需要输入账号的虚拟商品）的发奖，因为均需要用户输入地址或账号去手动领取，该字段无效
	 */
	private boolean directly;

	/**
	 * 来源渠道：1，app；2，微信H5；3，微信小程序
	 * @see cn.com.duiba.cloud.duiba.activity.service.api.enums.SourceTerminalTypeEnum
	 *  注：因为订单需要，所以前端传入来源，活动业务里带给订单
	 */
	private Integer sourceTerminal;

}
