package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.StrategyResult;
import cn.com.duiba.cloud.duiba.activity.service.api.param.StrategyBaseRequest;
import cn.com.duiba.cloud.duiba.activity.service.api.param.StrategyPrizeLimitRequest;
import cn.com.duiba.cloud.duiba.activity.service.api.param.StrategyRedirectRequest;

/**
 * @author zhengjianhao
 * @date 2022/4/1
 * @description 通用发奖api
 */
@AdvancedFeignClient
public interface RemoteStrategyService {

	/**
	 * 根据发奖规则概率出奖
	 * @param request
	 * @return
	 * @throws BizException
	 */
	StrategyResult sendProbability(StrategyBaseRequest request) throws BizException;

	/**
	 * 根据发奖规则概率出奖，且有奖品id限制，只能从传入的这些奖品id中出奖品
	 */
	StrategyResult sendProbabilityWithPrizeIdLimit(StrategyPrizeLimitRequest request) throws BizException;

	/**
	 * 出谢谢参与
	 */
	StrategyResult sendThanks(StrategyBaseRequest request) throws BizException;

	/**
	 * 直接出奖
	 */
	StrategyResult sendDirectly(StrategyRedirectRequest request) throws BizException;

}
