package cn.com.duiba.cloud.duiba.activity.service.api.enums.task;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;

public enum TaskCycleUnitEnum implements IEnum<Integer> {
    DAY(1, "每日"),
    WEEK(2, "每周"),
    MONTH(3, "每月"),
    YEAR(4, "每年"),
    ;
    private final Integer taskCycleUnit;
    private final String desc;

    TaskCycleUnitEnum(Integer taskCycleUnit, String desc) {
        this.taskCycleUnit = taskCycleUnit;
        this.desc = desc;
    }

    public Integer getTaskCycleUnit() {
        return taskCycleUnit;
    }

    public String getDesc() {
        return desc;
    }


    @Override
    public Integer getDbCode() {
        return getTaskCycleUnit();
    }


    /**
     * 计算两个日期的自然周期的相差值
     *
     * @param startDate 开始日期
     * @param endDate   结束日期
     *
     * @return
     */
    public static Long calculateNaturalPeriodBetween(TaskCycleUnitEnum taskCycleUnitEnum,
                                                     LocalDate startDate,
                                                     LocalDate endDate) {
        Long between = null;
        switch (taskCycleUnitEnum) {
            case DAY:
                between = ChronoUnit.DAYS.between(
                        startDate,
                        endDate);
                break;
            case WEEK:
                between = ChronoUnit.WEEKS.between(
                        convert2Monday(startDate),
                        endDate);
                break;
            case MONTH:
                between = ChronoUnit.MONTHS.between(
                        startDate.withDayOfMonth(1),
                        endDate.withDayOfMonth(1));
                break;
            case YEAR:
                between = ChronoUnit.YEARS.between(startDate.withDayOfYear(1),
                                                   endDate.withDayOfYear(1));
                break;
            default:

                break;
        }
        return between;
    }

    /**
     * 将日期改到周一
     */
    private static LocalDate convert2Monday(LocalDate localDate) {
        LocalDate result = localDate;
        DayOfWeek dayOfWeek = localDate.getDayOfWeek();
        switch (dayOfWeek) {
            case MONDAY:
                result = localDate.minusDays(0);
                break;
            case TUESDAY:
                result = localDate.minusDays(1);
                break;
            case WEDNESDAY:
                result = localDate.minusDays(2);
                break;
            case THURSDAY:
                result = localDate.minusDays(3);
                break;
            case FRIDAY:
                result = localDate.minusDays(4);
                break;
            case SATURDAY:
                result = localDate.minusDays(5);
                break;
            case SUNDAY:
                result = localDate.minusDays(6);
                break;
            default:
                break;
        }
        return result;
    }


    public static void main(String[] args) {
        LocalDate startDate = LocalDate.now();
        for (int i = 0; i < 3670; i++) {
            LocalDate endDate = startDate.plusDays(i);
            System.out.println(startDate);
            System.out.println(endDate);

            for (TaskCycleUnitEnum taskCycleUnitEnum : TaskCycleUnitEnum.values()) {
                System.out.println(taskCycleUnitEnum + ":" + TaskCycleUnitEnum.calculateNaturalPeriodBetween(taskCycleUnitEnum, startDate, endDate));
            }
        }
    }


}
