package cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.collect;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @Description 集卡活动卡片
 * @Author dangcang
 * @Date 2022/6/22 3:14 下午
 **/
@Data
public class ActivityCardVO implements Serializable {

    private static final long serialVersionUID = 24682920186582370L;
    /**
     * 卡片编号
     */
    @NotBlank(message = "卡片编号不能为空")
    private String cardCode;

    /**
     * 卡片名称
     */
    @NotBlank(message = "卡片名称不能为空")
    @Length(max = 10, message = "卡片名称不得超过10个字符")
    private String cardName;

    /**
     * 已获取卡片图片
     */
    @NotBlank(message = "已获取卡片图片不能为空")
    private String getCardImgSrc;

    /**
     * 未获取卡片图片
     */
    @NotBlank(message = "未获取卡片图片不能为空")
    private String notGetImgSrc;

    /**
     * 卡片展示文字
     */
    private String cardDesc;
}