package cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.collect;

import lombok.Data;
import org.hibernate.validator.constraints.Range;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Description 合成规则
 * @Author dangcang
 * @Date 2022/6/24 4:14 下午
 **/
@Data
public class CardMergeRuleListVO implements Serializable {

    private static final long serialVersionUID = -3854486792789216352L;
    /**
     * 合成所需卡片
     */
    @NotEmpty(message = "合成所需卡片列表不能为空")
    @Valid
    private List<CardMergeRuleVO> cardMergeRules;

    /**
     * 规则编码
     */
    @NotBlank(message = "规则编码不能为空")
    private String ruleCode;

    @Data
    public static class CardMergeRuleVO implements Serializable {

        private static final long serialVersionUID = 5669953037538782776L;
        /**
         * 卡片编号
         */
        @NotBlank(message = "卡片编号不能为空")
        private String cardCode;

        /**
         * 合成需要数量
         */
        @NotNull(message = "合成所需数量不能为空")
        @Range(min = 1, max =  9999, message = "请填写1-9999之间的整数")
        private Integer mergeNeedNum;
    }
}