package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways;

import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.remote.RemoteKeyValueApi;
import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.remote.RemoteLockService;
import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.remote.RemoteQueryTableService;
import cn.com.duiba.cloud.duiba.activity.service.api.utils.Field;

import javax.annotation.Resource;

public abstract class AbstractPlayWay {

    @Resource
    private RemoteQueryTableService queryTableService;
    @Resource
    protected RemoteKeyValueApi keyValueApiMySql;
    @Resource
    private RemoteLockService lockService;

    /**
     * 创建一个分布式锁
     *
     * @param key
     * @param expireSeconds
     * @return
     */
    protected DistributedLock newLock(Long activityId, String key, int expireSeconds) {
        return lockService.newLock(redisKey(activityId, key), expireSeconds);
    }

    protected <T extends Field> QueryTable<T> getTable(Long activityId, String group, Class<T> clazz) {
        return new QueryTableImpl<>(group, clazz, activityId, queryTableService);
    }

    /**
     * 生成项目环境的rediSkey
     * @param key
     * @return
     */
    private String redisKey(Long activityId, String key) {
        return activityId + "-" + key;
    }

}
