package cn.com.duiba.cloud.duiba.activity.service.api.enums.task;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;

public enum RewardStatusEnum implements IEnum<Integer> {
    WAIT_ACCEPT(0, "待领取"),

    @Deprecated
    WAIT_REWARD(1, "待发奖"),

    REWARD_ING(4, "发奖中"),

    REWARD_SUCCESS(2, "发奖成功"),

    REWARD_FAIL(3, "发奖失败"),
    ;

    private final Integer rewardStatus;
    private final String desc;

    RewardStatusEnum(Integer rewardStatus, String desc) {
        this.rewardStatus = rewardStatus;
        this.desc = desc;
    }

    public Integer getRewardStatus() {
        return rewardStatus;
    }

    public String getDesc() {
        return desc;
    }


    @Override
    public Integer getDbCode() {
        return getRewardStatus();
    }
}
