package cn.com.duiba.cloud.duiba.activity.service.api.enums.vote;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author sunyan
 */

@Getter
@AllArgsConstructor
public enum VoteItemShowTypeEnum {
    TIME(1,"审核时间"),
    COUNT(2,"投票数量");

    private Integer status;

    private String desc;
    public static VoteItemShowTypeEnum getByStatus(Integer status){
        VoteItemShowTypeEnum typeEnum = Arrays.asList(VoteItemShowTypeEnum.values()).stream().filter(i -> Objects.equals(i.getStatus(), status)).findFirst().orElse(null);
        return typeEnum;
    }
}
