package cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.signup;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 报名题目
 * @author sunyan
 */
@Data
public class SignupQuestionConfigVO implements Serializable {

    private static final long serialVersionUID = 4349913657136166645L;
    /**
     * 题目编号
     */
    @NotNull(message = "题目编号不能为空")
    private Integer questionNum;

    /**
     * 题型选择
     * 1-单选；2-多选；3-填空；4-省市区；5-日期；6-邮寄地址
     */
    @NotNull(message = "题型选择不能为空")
    private Integer questionType;

    /**
     * 填写校验
     * 1-必填；2非必填
     */
    @NotNull(message = "填写校验不能为空")
    private Integer required;

    /**
     * 题目描述，最多50个字
     */
    @NotNull(message = "题目描述不能为空")
    private String title;

    /**
     * 选项列表
     */
    private List<SignupOptionConfigVO> optionList;

    /**
     * 邮寄地址题目描述（用;间隔）
     * 例:（联系人;联系电话;所在地区;详细地址;邮政编码）
     */
    private String subTitle;


}
