package cn.com.duiba.cloud.duiba.activity.service.api.param.task;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Setter
@Getter
public class TaskUserBatchParam implements Serializable {
    private static final long serialVersionUID = 1L;

    @NotNull
    private Long userId;

    @Size(min = 1)
    private List<Item> taskList = new ArrayList<>();

    @Setter
    @Getter
    public static class Item implements Serializable {
        private Long taskId;
        private Integer cycleNo;

        public Item(Long taskId, Integer cycleNo) {
            this.taskId = taskId;
            this.cycleNo = cycleNo;
        }

        public Item() {
        }
    }

}
