package cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.activityData;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 积分商城活动留存数据
 */
@Data
public class ActivityKeepDTO implements Serializable {
    private static final long serialVersionUID = -8903604973661300459L;

    /**
     * 主键ID
     */
    private Long id;
    
    /**
     * 活动Id
     */
    private Long activityId;

    /**
     * 数据时间
     */
    private Date curDate;

    /**
     * 统计维度  1:新访客 2:老访客
     */
    private Integer itemScope;

    /**
     * 指标类型: 1:访问留存 2:参与留存
     */
    private Integer keepType;

    /**
     * 来源渠道 1:应用 2:公众号 3:小程序 未知：-1
     */
    private Integer channelSource;

    /**
     * 纬度类型：1:用户类型 2：渠道
     */
    private Integer dimType;

    /**
     * 总人数
     */
    private Long allCount;

    /**
     * 次日
     */
    private Long dataCount1;

    /**
     * 2日
     */
    private Long dataCount2;

    /**
     * 3日
     */
    private Long dataCount3;

    /**
     * 4日
     */
    private Long dataCount4;

    /**
     * 5日
     */
    private Long dataCount5;

    /**
     * 6日
     */
    private Long dataCount6;

    /**
     * 7日
     */
    private Long dataCount7;

    /**
     * 10日
     */
    private Long dataCount10;

    /**
     * 15日
     */
    private Long dataCount15;

    /**
     * 30日
     */
    private Long dataCount30;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;


}