package cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.activityData;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 积分商城活动趋势数据-今日数据
 */
@Data
public class ActivityTrendDailyDTO implements Serializable {
    private static final long serialVersionUID = -5884217674135262981L;

    /**
     * 活动Id
     */
    private Long activityId;

    /**
     * 最近的刷新时间
     */
    private Date lastUpdateTime;

    /**
     * 活动访问次数
     */
    private Long visitPv;

    /**
     * 活动访问人数
     */
    private Long visitUv;

    /**
     * 参与活动次数
     */
    private Long joinPv;

    /**
     * 参数活动人数
     */
    private Long joinUv;

    /**
     * 消耗积分数
     */
    private Long costPoint;

    /**
     * 消耗积分人数
     */
    private Long costPointPerCount;

    /**
     * 分享活动次数
     */
    private Long sharePv;

    /**
     * 分享活动人数
     */
    private Long shareUv;

    /**
     * 邀请发起次数（总数）
     */
    private Long invitePv;

    /**
     * 邀请发起人数
     */
    private Long inviteUv;

    /**
     * 助力次数
     */
    private Long helpPv;

    /**
     * 助力人数
     */
    private Long helpUv;

    /**
     * 中奖人数
     */
    private Long winCount;

    /**
     * 领奖人数
     */
    private Long drawCount;

    /**
     * 总访问时长
     */
    private Long sumVisitTime;

    /**
     * 总游戏时长
     */
    private Long sumGameTime;

    /**
     * 分享页访问次数
     */
    private Long shareVisitPv;

    /**
     * 分享页访问人数
     */
    private Long shareVisitUv;

    /**
     * 有访问时长的uv
     */
    private Long sumVisitTimeUv;

    /**
     * 有游戏时长的uv
     */
    private Long sumGameTimeUv;
}