package cn.com.duiba.cloud.duiba.activity.service.api.dto.seckill;

import cn.com.duiba.cloud.duiba.activity.service.api.dto.BaseDto;
import cn.com.duiba.cloud.duiba.activity.service.api.enums.DeletedEnum;
import cn.com.duiba.cloud.duiba.activity.service.api.enums.seckill.SeckillActRunModeEnum;
import cn.com.duiba.cloud.duiba.activity.service.api.enums.seckill.SeckillActStatusEnum;
import lombok.Getter;
import lombok.Setter;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 秒杀活动配置
 *
 * @TableName tb_seckill_act_conf
 */
@Setter
@Getter
public class SeckillActConfDto extends BaseDto {
    private static final long serialVersionUID = 1L;

    /**
     * 所属应用id
     */
    private Long appId;

    /**
     * 有效状态：0-有效，10-已失效
     *
     * @see SeckillActStatusEnum
     */
    private Integer enableStatus;

    /**
     * 活动名称
     */
    private String title;

    /**
     * 单人限购上限
     */
    private Integer perLimit;

    /**
     * 开始时间
     */
    private Date gmtStart;

    /**
     * 结束时间
     */
    private Date gmtEnd;

    /**
     * 商品id
     */
    private Long spuId;

    /**
     * 商品类型
     */
    private String spuType;

    /**
     * 商品标题
     *
     * @deprecated 实时从商品另取
     */
    @Deprecated
    private String spuTitle;

    /**
     * 删除标记:0-未删除，1-已删除
     *
     * @see DeletedEnum
     */
    private Integer deleted;

    /**
     * 秒杀活动标签
     */
    private String seckillTag;

    /**
     * 模式:0-单次，1-循环
     *
     * @see SeckillActRunModeEnum
     */
    private Integer runMode;

    /**
     * sku信息
     */
    private List<SeckillActSkuConfDto> skuConfDtoList = new ArrayList<>();
}