package cn.com.duiba.cloud.duiba.activity.service.api.dto.seckill;

import cn.com.duiba.cloud.duiba.activity.service.api.dto.BaseDto;
import cn.com.duiba.cloud.duiba.activity.service.api.enums.seckill.SeckillActStatusEnum;
import lombok.Getter;
import lombok.Setter;

import java.util.ArrayList;
import java.util.List;

/**
 * 秒杀活动sku配置
 *
 * @TableName tb_seckill_act_sku_conf
 */
@Setter
@Getter
public class SeckillActSkuConfDto extends BaseDto {
    private static final long serialVersionUID = 1L;

    /**
     * 活动id
     */
    private Long actId;

    /**
     * app sku id
     */
    private Long appSkuId;

    /**
     * 有效状态：0-有效，10-已失效
     *
     * @see SeckillActStatusEnum
     */
    private Integer enableStatus;

    /**
     * 规格
     */
    private String specConf;

    /**
     * 原价需要钱（单位：分）
     *
     * @deprecated 从商品另取
     */
    @Deprecated
    private Long price;

    /**
     * 原价需要积分
     *
     * @deprecated 从商品另取
     */
    @Deprecated
    private Long credits;

    /**
     * 秒杀需要钱（单位：分）
     */
    private Long secPrice;

    /**
     * 秒杀需要积分
     */
    private Long secCredits;

    /**
     * 秒杀上限
     */
    private Integer secLimit;


    /**
     * 秒杀数据
     */
    private List<SeckillActSkuDataDto> skuDataList = new ArrayList<>();


    /**
     * 剩余预占库存
     */
    private Long leftOccupyStock;
}