package cn.com.duiba.cloud.duiba.activity.service.api.enums;

import cn.com.duiba.wolf.entity.Pair;
import lombok.Getter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Triple;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

/**
 * @author fss
 * @Description:分层书奖：多奖池出奖的ruleKey前缀枚举
 */
@Getter
public enum ActivityRuleKeyEnum {

    RULE_VIP_KEY("1_", "会员多奖池配置前缀"),
    RULE_LABEL_KEY("2_", "标签多奖池配置前缀"),
    ;

    public static final String SPLIT = "_";

    /**
     * 多身份识别时,一个字段去兼容的使用该分割符(前端组建不好处理)
     */
    public static final String ONE_FIELD_SPLIT = "_;_";

    public static final Integer SPLIT_SIZE = 2;

    private String ruleKey;

    private String desc;

    ActivityRuleKeyEnum(String ruleCode, String desc) {
        this.ruleKey = ruleCode;
        this.desc = desc;
    }

    private static final Map<String, ActivityRuleKeyEnum> ENUM_MAP = new HashMap<>();

    static {
        for (ActivityRuleKeyEnum tmp : values()) {
            ENUM_MAP.put(tmp.getRuleKey(), tmp);
        }
    }

    /**
     * vip匹配
     * @param ruleKey
     * @param userGrade
     * @return
     */
    public static final boolean matchVip(String ruleKey, Integer userGrade) {
        if (StringUtils.isEmpty(ruleKey)) {
            return false;
        }
        String[] split = ruleKey.split(ActivityRuleKeyEnum.SPLIT);
        if (split.length < ActivityRuleKeyEnum.SPLIT_SIZE) {
            return false;
        }
        Integer configGrade = Integer.parseInt(split[1]);
        return Objects.equals(userGrade, configGrade);
    }

    /**
     * ruleKey基础校验
     *
     * @param ruleKey
     * @return
     */
    public static final boolean verify(String ruleKey) {
        if (StringUtils.isEmpty(ruleKey)) {
            return false;
        }
        String[] split = ruleKey.split(ActivityRuleKeyEnum.SPLIT);
        return split.length < ActivityRuleKeyEnum.SPLIT_SIZE;
    }

    /**
     * 标签匹配
     * @param ruleKey
     * @param labelIdSet
     * @return
     */
    public static final boolean matchLabel(String ruleKey, Set<Long> labelIdSet) {
        if (StringUtils.isEmpty(ruleKey)) {
            return false;
        }
        String[] split = ruleKey.split(ActivityRuleKeyEnum.SPLIT);
        if (split.length < ActivityRuleKeyEnum.SPLIT_SIZE) {
            return false;
        }
        Long configLabelId = Long.parseLong(split[1]);
        return labelIdSet.contains(configLabelId);
    }

    /**
     * 校验该属性配置以哪种方式判断
     * @param keyword
     * @return 是否是新版本校验,校验身份类型,身份ID
     */
    public static final Triple<Boolean,Integer,Integer> isNewLimit(String keyword) {
        if (StringUtils.isEmpty(keyword)) {
            return Triple.of(false, null, null);
        }
        String[] split = keyword.split(ActivityRuleKeyEnum.ONE_FIELD_SPLIT);
        if (split.length < ActivityRuleKeyEnum.SPLIT_SIZE) {
            return Triple.of(false, null, null);
        }
        return Triple.of(split.length >= ActivityRuleKeyEnum.SPLIT_SIZE, Integer.parseInt(split[0]), Integer.parseInt(split[1]));
    }

    public static ActivityRuleKeyEnum getByCode(String code) {
        return ENUM_MAP.get(code);
    }
}
