package cn.com.duiba.cloud.duiba.activity.service.api.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;


/**
 * @author fss
 */
@Getter
public enum ActivityTemplateCodeEnum {

    SQUARETURNTABLE("square-turntable", "大转盘"),

    EGGTWISTER( "egg-twister", "扭蛋机"),

    DUOSHOU("duoshou", "剁手"),

    TIANJIANGYOULI("tianjiangyouli", "天降有礼"),

    CHAIKUAIDI("chaikuaidi", "拆快递"),

    DAQIQIU("daqiqiu", "打气球"),

    TAOQUAN("taoquan", "套圈"),

    JUMP("jump", "跳房子"),

    BLINDBOX("Blindbox", "拆盲盒"),

    WENJUAN("wenjuan", "报名问卷"),

    ANWSER("anwser", "答题活动"),

    JUMPGAME( "jump-game", "跳一跳"),

    PINTU( "pintu", "拼图"),

    RILIQIANDAO("riliqiandao", "日历签到"),
    ;

    private String templateCode;

    private String desc;

    ActivityTemplateCodeEnum(String templateCode, String desc) {
        this.templateCode = templateCode;
        this.desc = desc;
    }

    private static final Map<String, ActivityTemplateCodeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (ActivityTemplateCodeEnum tmp : values()) {
            ENUM_MAP.put(tmp.getTemplateCode(), tmp);
        }
    }

    public static ActivityTemplateCodeEnum getByCode(String code) {
        return ENUM_MAP.get(code);
    }
}
