package cn.com.duiba.cloud.duiba.activity.service.api.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author fss
 * @Description:分层书奖：多奖池出奖的ruleKey前缀枚举
 */
@Getter
public enum IdentityTypeEnum {

    VIP_TYPE(1, "会员类型"), LABEL_TYPE(2, "标签类型");

    private Integer type;

    private String desc;

    IdentityTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, IdentityTypeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (IdentityTypeEnum tmp : values()) {
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }

    public static IdentityTypeEnum getByCode(String code) {
        return ENUM_MAP.get(code);
    }
}
