package cn.com.duiba.cloud.duiba.activity.service.api.enums.activitytask;

import java.util.Arrays;
import java.util.Objects;

/**
 * @date:2022/6/25 14:24
 * @author:zhaozhanghai
 * @Description: 活动任务奖励有效期类型
 */
public enum ActivityTaskVaildTypeEnum {

    TASK(1,"跟随任务"),
    EVERYDAY(2,"每日"),
    FOREVER(3,"永久"),
    CUSTOM(4,"自定义"),
    ;

    ActivityTaskVaildTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private Integer type;
    private String desc;


    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static ActivityTaskVaildTypeEnum getByCode(Integer type){
        return Arrays.stream(ActivityTaskVaildTypeEnum.values()).filter(i -> Objects.equals(i.getType(), type)).findFirst().orElse(null);
    }
}
