package cn.com.duiba.cloud.duiba.activity.service.api.enums.collect;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description 集卡活动分享配置
 * @Author dangcang
 * @Date 2022/6/27 2:51 下午
 **/
@Getter
public enum HelpTypeEnum {

    EVERY_DAY(1, "次/每日"),
    PERPETUAL(2, "次/永久")
    ;

    private Integer type;

    private String desc;

    HelpTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static Map<Integer, HelpTypeEnum> map = new HashMap<Integer, HelpTypeEnum>() {{
        for (HelpTypeEnum helpTypeEnum : HelpTypeEnum.values()) {
            put(helpTypeEnum.getType(), helpTypeEnum);
        }
    }};

    public static HelpTypeEnum getByType(Integer type) {
        return map.get(type);
    }
}