package cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.base;

import cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.rank.RankPrizeVo;
import lombok.Data;
import org.hibernate.validator.constraints.Range;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * @date:2022/4/1 11:39
 * @author:zhaozhanghai
 * @Description: 活动发奖规则
 */
@Data
public class BaseRuleVo implements Serializable {

    /**
     * 规则code
     */
    private String ruleCode;

    /**
     * ruleKey:多奖池出奖，根据ruleKey确定用户所属奖池
     */
    private String ruleKey;

    /**
     * 用户分层出奖 0-不开启 1-开启
     */
    @Range(min = 0,max = 1,message = "用户分层出奖类型错误")
    private Integer isIdentityLayeredPrize;

    /**
     * 多奖项中奖限制开启 0-不开启 1-开启
     */
    @Range(min = 0,max = 1,message = "多奖项中奖限制开启类型错误")
    private Integer isMorePrize;

    /**
     * 多奖项配置
     */
    @Valid
    private BaseMorePrizeVo morePrize;

    /**
     * 百分百中奖开启 0-不开启 1-开启
     */
    @Range(min = 0,max = 1,message = "百分百中奖开启类型错误")
    private Integer absolutelyPrize;
    /**
     * 概率出奖奖品配置
     */
    @NotEmpty(message = "奖品数量不能为空")
    @Valid
    private List<BasePrizeVo> prizeList;
    /**
     * 百分百出奖奖品配置
     */
    @Valid
    private List<BasePrizeVo> absolutelyPrizeList;

    /**
     * 排行榜奖品
     */
    @Valid
    private List<RankPrizeVo> rankPrizeList;

    /**
     * 根据不同的活动类型解析 开发人员自已定义实体类解析
     */
    private List<String> generalPrizeList;

    /**
     * 奖品扩展字段
     */
    private String ext;

    /**
     * 前端标识
     */
    private String identifierCode;

}
