package cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.base;

import lombok.Data;
import org.hibernate.validator.constraints.Range;

import java.io.Serializable;
import java.util.List;

/**
 * @date:2022/3/24 16:16
 * @author:zhaozhanghai
 * @Description: 活动用户分层参与配置
 */
@Data
public class BaseUserLayeredJoinVo implements Serializable {
    /**
     * 用户身份（之前是code，全部转换为ID标识，之前code做业务兼容）
     */
    private String identity;

    /**
     * 用户身份类型:1:会员;2:标签;3:人群包;为空默认会员(兼容之前数据)
     */
    private Integer identityType;

    /**
     * 参与积分数
     */
    private Integer joinCredits;

    /**
     * 参与次数限制
     */
    private Integer joinLimit;

    /**
     * 参与次数限制单位 1-次/每天 2-次/永久
     */
    private Integer joinLimitUnit;

    /**
     * 参与免费次数
     */
    private Integer joinFreeLimit;

    /**
     * 参与免费次数单位 1-次/每天 2-次/永久
     */
    private Integer joinFreeLimitUnit;

    /**
     * 排序
     */
    private Integer sort;

    /**
     * 前端回显使用数组
     */
    private List<String> identityArr;

}
