package cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.collect;

import lombok.Data;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Description 助力规则基础配置
 * @Author dangcang
 * @Date 2022/6/27 3:10 下午
 **/
@Data
public class BaseShareConfigVO implements Serializable {

    private static final long serialVersionUID = 2393227372901349854L;
    /**
     * 助力次数
     */
    @NotNull(message = "助力次数不能为空")
    @Range(min = 1, max =  9999, message = "请填写1-9999之间的整数")
    private Integer shareNum;

    /**
     * 助力类型
     * @see cn.com.duiba.cloud.duiba.activity.service.api.enums.collect.HelpTypeEnum
     */
    @NotNull(message = "助力类型不能为空")
    @Range(min = 1, max = 2, message = "助力类型错误")
    private Integer shareType;

    /**
     * 助力规则
     */
    private List<ShareCardRewardVO> shareCardRewardList;

    /**
     * 规则编码
     */
    @NotBlank(message = "规则编码不能为空")
    private String ruleCode;
    
    @Data
    public static class ShareCardRewardVO implements Serializable {

        private static final long serialVersionUID = -1559287063265807336L;
        /**
         * 卡片编号
         */
        @NotBlank(message = "卡片编号不能为空")
        private String cardCode;
    }
}