package cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.collect;

import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * @Description 集卡活动特有参数
 * @Author dangcang
 * @Date 2022/6/22 2:13 下午
 **/
@Data
public class CollectCardVO implements Serializable {

    private static final long serialVersionUID = -4591027036564183991L;

    /**
     * 卡片列表
     */
    @NotEmpty(message = "卡片数在2-8之间")
    @Size(min = 2, max = 8, message = "卡片数在2-8之间")
    @Valid
    private List<ActivityCardVO> cardList;

    /**
     * 合成规则
     */
    @NotEmpty(message = "合成规则不能为空")
    @Valid
    @Size(min = 1, max = 10, message = "合成奖品在1-10之间")
    private List<CardMergeRuleListVO> cardMergeRuleList;

    /**
     * 被助力配置
     */
    private BaseShareConfigVO shareConfig;

    /**
     * 助力配置
     */
    private ShareConfigToVO shareConfigTo;

}