package cn.com.duiba.cloud.duiba.activity.service.api.param.activityData;

import lombok.Data;
import org.apache.commons.lang3.ObjectUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * 功能描述：单个活动的留存数据请求参数
 *
 * @Auther: xiaotian
 * @Date: 2022/4/14 10:33
 * @Description:
 */
@Data
public class ActivityKeepPageParam implements Serializable {

    private static final long serialVersionUID = -6253067411607943827L;
    /**
     * 活动ID
     */
    private Long activityId;
    /**
     * 开始时间
     */
    private Date start;
    /*
     * 结束时间
     */
    private Date end;

    /**
     * 指标类型: 1:访问留存 2:参与留存
     */
    private Integer keepType;

    /**
     * 统计维度  1:新访客 2:老访客
     */
    private Integer itemScope;

    /**
     * 来源渠道 1:应用 2:公众号 3:小程序 未知：-1
     */
    private Integer channelSource;

    /**
     * 纬度类型：1:用户类型 2：渠道
     */
    private Integer dimType;


    public Integer getDimType() {
        if (ObjectUtils.allNotNull(this.itemScope, this.channelSource)) {
            return 2;
        } else if (ObjectUtils.allNotNull(this.itemScope)) {
            return 1;
        } else if (ObjectUtils.allNotNull(this.channelSource)) {
            return 2;
        } else {
            return 1;
        }
    }
}
