package cn.com.duiba.cloud.duiba.activity.service.api.param.seckill;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

@Setter
@Getter
public class SecKillActPageParam extends PageRequest {

    private static final long serialVersionUID = 1L;

    /**
     * 应用Id
     */
    @NotNull
    private Long appId;

    /**
     * 活动名称
     */
    private String title;


    /**
     * 商品id
     */
    private Long spuId;

    /**
     * 秒杀状态
     * 0-未开始，10-进行中，20-已结束，other-全部
     */
    private Integer status;


    private List<Long> actIdList = new ArrayList<>();


    /**
     * 是否需要查询sku配置
     */
    private Boolean needSkuConf = Boolean.FALSE;

    /**
     * 是否需要查询sku剩余预占库存
     */
    private Boolean needLeftOccupyStock = Boolean.FALSE;
}
