package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.MallActivityDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.MallActivitySimpleDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.PrizeRecordReceiveDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.base.BaseActivityVo;
import cn.com.duiba.cloud.duiba.activity.service.api.param.ActivityAddRequest;
import cn.com.duiba.cloud.duiba.activity.service.api.param.ActivityQueryParam;
import cn.com.duiba.wolf.entity.PageRequest;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * @date:2022/3/24 11:50
 * @author:zhaozhanghai
 * @Description: 活动服务
 */
@AdvancedFeignClient
public interface RemoteActivityService {


    /**
     * 新增活动和奖品
     * @param request@return 活动id
     * @throws BizException
     */
    Long addActivityAndPrize(ActivityAddRequest request) throws BizException;


    /**
     * 修改活动和奖品
     * @param request@return
     */
    Boolean updateActivityAndPrize(ActivityAddRequest request) throws BizException;

    MallActivityDTO getByActivityId(Long activityId);

    /**
     * 删除活动
     *
     * @param activityId
     * @return
     */
    Boolean delete(Long activityId);

    /**
     * 更新活动状态
     *
     * @param activityId
     * @param status
     * @return
     */
    Boolean updateStatus(Long activityId, Integer status);

    /**
     * 分页查询
     *
     * @param page
     * @param dto
     * @return
     */
    PageResponse<MallActivityDTO> page(PageRequest page, MallActivityDTO dto);

    /**
     * 分页查询（活动数据）
     *
     * @param activityQueryParam
     * @return
     */
    PageResponse<MallActivityDTO> pageList(ActivityQueryParam activityQueryParam);


    /**
     * 活动详情
     *
     * @param activityId
     * @return
     * @throws BizException
     */
    BaseActivityVo detail(Long activityId) throws BizException;

    /**
     * 获取活动奖品领取信息
     *
     * @param activityId
     * @param prizeIds
     * @return
     */
    List<PrizeRecordReceiveDTO> getActivityPrizeReceiveNum(Long activityId, List<Long> prizeIds);

    /**
     * 获取活动基础信息列表
     *
     * @param appId
     * @return
     */
    List<MallActivitySimpleDTO> listSimpleActivityByAppId(Long appId);


    /**
     * 批量获取活动基础信息列表
     *
     * @param activityIds
     * @return
     */
    List<MallActivitySimpleDTO> listSimpleActivityByIds(List<Long> activityIds);


    /**
     * 获取活动列表
     *
     * @param appId
     * @param status
     * @return
     */
    List<MallActivityDTO> listByStatus(Long appId, Integer status);


    /**
     * 获取活动基础信息
     * @param activityId
     * @return
     */
    MallActivitySimpleDTO getSimpleActivityByActivityId(Long activityId);
    /**
     * 活动详情 不走缓存
     * @param activityId
     * @return
     * @throws BizException
     */
    BaseActivityVo detailNoCache(Long activityId) throws BizException;


    /**
     * 获取 进行中活动列表
     * @param appId
     * @param status 发布/下架 @see {@link cn.com.duiba.cloud.duiba.activity.service.api.enums.ActivityStatusEnum}
     * @param limit 限制
     * @return
     */
    List<MallActivityDTO> listGoingByStatus(Long appId, Integer status,Integer limit);


    /**
     * 根据appId和spuId、skuId查询活动：查询所有活动， 不用过滤活动状态
     */
    List<MallActivitySimpleDTO> listSimpleActivityByAppIdAndItem(Long appId, Long spuId, Long skuId) throws BizException;

    /**
     * 任务配置活动列表
     * @param appId
     * @param state
     * @param activityTypeList
     * @return
     * @throws BizException
     */
    List<MallActivitySimpleDTO> listSimpleActivityByAppIdAndStateAndActivityType(Long appId,Integer state,List<String> activityTypeList) throws BizException;

}
