package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.activityTask.ActivityTaskDto;
import cn.com.duiba.cloud.duiba.activity.service.api.param.activityTask.FinishTaskRewardParam;
import cn.com.duiba.cloud.duiba.activity.service.api.param.activityTask.TryMinusRewardCountParam;
import cn.com.duiba.cloud.duiba.activity.service.api.param.activityTask.ValidRewardTimesParam;

import java.util.List;

/**
 * @date:2022/4/14 11:50
 * @author:zhaozhanghai
 * @Description: 活动任务
 */
@AdvancedFeignClient
public interface RemoteActivityTaskService {


    /**
     * 获取该活动的配置的任务
     *
     * @param activityId
     * @return
     */
    List<ActivityTaskDto> activityTasks(Long activityId);


    /**
     * 尝试减去奖励的有效次数
     *
     * @param tryMinusRewardCountParam
     * @return
     */
    boolean tryMinusRewardCount(TryMinusRewardCountParam tryMinusRewardCountParam);


    /**
     * 获取有效的奖励参与次数
     *
     * @param validRewardTimesParam
     * @return
     */
    Integer getValidRewardTimes(ValidRewardTimesParam validRewardTimesParam);


    /**
     * 用户完成任务，发放奖励
     *
     * @param finishTaskRewardParam
     * @return
     */
    boolean finishTaskReward(FinishTaskRewardParam finishTaskRewardParam) throws BizException;

}
