package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.vote.VoteItemDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.vote.VoteItemDataDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.param.vote.VoteItem2CQueryParam;
import cn.com.duiba.cloud.duiba.activity.service.api.param.vote.VoteItemQueryParam;
import cn.com.duiba.cloud.duiba.activity.service.api.param.vote.VoteParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 投票项服务
 * @author sunyan
 */
@AdvancedFeignClient
public interface RemoteVoteItemService {
    /**
     * cms用分页查询
     * @param voteItemQueryParam
     * @return
     */
    PageResponse<VoteItemDTO> page4cms(VoteItemQueryParam voteItemQueryParam) throws BizException;
    /**
     * cms导出列表
     * @param voteItemQueryParam
     * @return
     */
    List<VoteItemDTO> list4cms(VoteItemQueryParam voteItemQueryParam) throws BizException;
    /**
     * 待审核数量
     * @param activityId
     * @return
     */
    Long selectCntInExamine(Long activityId);

    /**
     * 投票
     * @param voteParam
     * @return
     * @throws BizException
     */
    Boolean vote(VoteParam voteParam) throws BizException;

    /**
     * 新增投票项
     * @param voteItemDTO
     * @return
     */
    Long addItem(VoteItemDTO voteItemDTO) throws BizException;

    /**
     * 审核投票项
     * @param id
     * @param examine
     * @param operator
     * @return
     * @throws BizException
     */
    Boolean examineItem(Long id,Boolean examine,String operator) throws BizException;

    /**
     * 删除投票项
     * @param id
     * @param operator
     * @return
     * @throws BizException
     */
    Boolean delItem(Long id,String operator) throws BizException;

    /**
     * 按id查询
     * @param id
     * @return
     */
    VoteItemDTO findItemById(Long id);
    /**
     * 按id查询
     * @param activityId
     * @param cid
     * @return
     */
    VoteItemDTO selectByCid(Long activityId,Long cid);
    /**
     * 投票数据
     * @param activityId
     * @return
     */
    VoteItemDataDTO findItemData(Long activityId) throws BizException;

    /**
     * c端分页查询（待缓存）
     * @param voteItem2CQueryParam
     * @return
     * @throws BizException
     */
    PageResponse<VoteItemDTO> page2c(VoteItem2CQueryParam voteItem2CQueryParam) throws BizException;

    /**
     * 查询我的排名位置，最多查到前999名，超出返回null
     *
     * @param activityId
     * @param cid
     * @return
     */
    Integer getMyRank(Long activityId,Long cid);

}
