package cn.com.duiba.cloud.duiba.activity.service.api.utils;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;

import java.util.Date;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/6/16 2:31 下午
 **/
public class MyDateUtil {

    private MyDateUtil() {
    }

    private static final Long DAY_SECOND = 86400L;

    /**
     * 返回相隔的天数
     * 一般认知中的间隔天数
     * 7、8、9 3天
     * @param beginDate 某天的开始
     * @param endDate 某天的结束
     * @return
     */
    public static Long between(Date beginDate, Date endDate) {

        Long intervalSecond = DateUtil.between(DateUtil.beginOfDay(beginDate), DateUtil.endOfDay(endDate), DateUnit.SECOND);
        Long intervalDay = 0L;
        while (intervalSecond > 0) {
            intervalDay++;
            intervalSecond -= DAY_SECOND;
        }
        return intervalDay;
    }
}