/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.QueryTable;
import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.dto.PairDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.dto.PlaywayQuerytableDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.remote.RemoteQueryTableService;
import cn.com.duiba.cloud.duiba.activity.service.api.utils.Field;
import cn.com.duiba.cloud.duiba.activity.service.api.utils.PageList;
import cn.com.duiba.cloud.duiba.activity.service.api.utils.QueryTableItem;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.EnumUtils;

public class QueryTableImpl<T extends Field>
implements QueryTable<T> {
    private String group;
    private Class<T> fieldClass;
    private HashBiMap<T, Field.PresetField> mapper = HashBiMap.create();
    private RemoteQueryTableService queryTableService;
    private Long activityId;

    public QueryTableImpl(String group, Class<T> fieldClass, Long activityId, RemoteQueryTableService queryTableService) {
        this.group = group;
        this.fieldClass = fieldClass;
        this.activityId = activityId;
        this.queryTableService = queryTableService;
        this.init();
    }

    private void init() {
        List enumList = EnumUtils.getEnumList(this.fieldClass);
        for (Enum aEnum : enumList) {
            this.mapper.put((Object)((Field)((Object)aEnum)), (Object)((Field)((Object)aEnum)).getField());
        }
    }

    @Override
    public QueryTableItem<T> newItem() {
        return new InnerItem(new PlaywayQuerytableDTO());
    }

    @Override
    public void add(QueryTableItem<T> item) {
        PlaywayQuerytableDTO entity = ((InnerItem)item).entity;
        entity.setActivityId(this.activityId);
        this.queryTableService.add(entity);
    }

    @Override
    public boolean update(long id, Field type, Object value) {
        InnerItem<Field> item = new InnerItem<Field>(new PlaywayQuerytableDTO());
        item.set(type, value);
        return this.queryTableService.updateById(this.activityId, this.group, id, ((InnerItem)item).entity);
    }

    @Override
    public boolean update(long id, QueryTableItem<T> item) {
        PlaywayQuerytableDTO entity = ((InnerItem)item).entity;
        return this.queryTableService.updateById(this.activityId, this.group, id, entity);
    }

    @Override
    public boolean delete(long id) {
        return this.queryTableService.deleteById(this.activityId, this.group, id);
    }

    @Override
    public boolean increase(long id, long delta, long max) {
        return this.queryTableService.increase(this.activityId, this.group, id, delta, max);
    }

    @Override
    public List<QueryTableItem<T>> query(Field type1, Object value1, Field type2, Object value2) {
        ArrayList<PairDTO<Integer, Object>> queryList = new ArrayList<PairDTO<Integer, Object>>(2);
        if (null != type1) {
            queryList.add(PairDTO.from(type1.getField().getId(), value1));
        }
        if (null != type2) {
            queryList.add(PairDTO.from(type2.getField().getId(), value2));
        }
        if (CollectionUtils.isEmpty(queryList)) {
            return Collections.emptyList();
        }
        List<PlaywayQuerytableDTO> result = this.queryTableService.querySorted(this.activityId, this.group, queryList, 8, 1, 1L, 2000L);
        return this.toItemList(result);
    }

    @Override
    public List<QueryTableItem<T>> queryList(Field type, List<Object> values) throws BizException {
        if (CollectionUtils.isEmpty(values)) {
            return Collections.emptyList();
        }
        if (values.size() > 200) {
            throw new BizException("\u6279\u91cf\u67e5\u8be2\u957f\u5ea6\u4e0d\u5f97\u5927\u4e8e200\uff01");
        }
        return this.toItemList(this.queryTableService.batchQuery(this.activityId, this.group, type.getField().getId(), values));
    }

    @Override
    public PageList<QueryTableItem<T>> pageQuery(Field queryType, Object value, long pageNum, long pageSize) {
        return this.pageQuery(queryType, value, null, null, pageNum, pageSize);
    }

    @Override
    public PageList<QueryTableItem<T>> inexplicitPageQuery(Field queryType, String value, long pageNum, long pageSize) {
        long totalCount;
        List<PairDTO<Integer, Object>> queryList = Collections.emptyList();
        if (queryType != null) {
            queryList = Collections.singletonList(PairDTO.from(queryType.getField().getId(), value));
        }
        if ((totalCount = this.queryTableService.inexplicitCount(this.activityId, this.group, queryList)) == 0L) {
            return PageList.of(0L, pageSize, Collections.emptyList());
        }
        List<PlaywayQuerytableDTO> result = this.queryTableService.inexplicitQuerySorted(this.activityId, this.group, queryList, Field.PresetField.ID.getId(), 1, pageNum, pageSize);
        return PageList.of(totalCount, pageSize, this.toItemList(result));
    }

    @Override
    public List<QueryTableItem<T>> queryNoSort(Field type1, Object value1, Field type2, Object value2) {
        ArrayList<PairDTO<Integer, Object>> queryList = new ArrayList<PairDTO<Integer, Object>>(2);
        queryList.add(PairDTO.from(type1.getField().getId(), value1));
        queryList.add(PairDTO.from(type2.getField().getId(), value2));
        List<PlaywayQuerytableDTO> result = this.queryTableService.query(this.activityId, this.group, queryList, 1L, 2000L);
        return this.toItemList(result);
    }

    @Override
    public PageList<QueryTableItem<T>> pageQueryNoSort(Field queryType, Object value, long pageNum, long pageSize) {
        long totalCount;
        List<PairDTO<Integer, Object>> queryList = Collections.emptyList();
        if (queryType != null) {
            queryList = Collections.singletonList(PairDTO.from(queryType.getField().getId(), value));
        }
        if ((totalCount = this.queryTableService.count(this.activityId, this.group, queryList)) == 0L) {
            return PageList.of(0L, pageSize, Collections.emptyList());
        }
        List<PlaywayQuerytableDTO> result = this.queryTableService.query(this.activityId, this.group, queryList, pageNum, pageSize);
        return PageList.of(totalCount, pageSize, this.toItemList(result));
    }

    @Override
    public PageList<QueryTableItem<T>> inexplicitPageQueryNoSort(Field queryType, String value, long pageNum, long pageSize) {
        long totalCount;
        List<PairDTO<Integer, Object>> queryList = Collections.emptyList();
        if (queryType != null) {
            queryList = Collections.singletonList(PairDTO.from(queryType.getField().getId(), value));
        }
        if ((totalCount = this.queryTableService.inexplicitCount(this.activityId, this.group, queryList)) == 0L) {
            return PageList.of(0L, pageSize, Collections.emptyList());
        }
        List<PlaywayQuerytableDTO> result = this.queryTableService.inexplicitQuery(this.activityId, this.group, queryList, pageNum, pageSize);
        return PageList.of(totalCount, pageSize, this.toItemList(result));
    }

    @Override
    public PageList<QueryTableItem<T>> pageQuery(Field type1, Object value1, Field type2, Object value2, long pageNum, long pageSize) {
        long totalCount;
        if (type1 == null && type2 == null) {
            return PageList.of(0L, pageSize, Collections.emptyList());
        }
        ArrayList<PairDTO<Integer, Object>> queryList = new ArrayList<PairDTO<Integer, Object>>(2);
        if (type1 != null) {
            queryList.add(PairDTO.from(type1.getField().getId(), value1));
        }
        if (type2 != null) {
            queryList.add(PairDTO.from(type2.getField().getId(), value2));
        }
        if ((totalCount = this.queryTableService.count(this.activityId, this.group, queryList)) == 0L) {
            return PageList.of(0L, pageSize, Collections.emptyList());
        }
        List<PlaywayQuerytableDTO> result = this.queryTableService.querySorted(this.activityId, this.group, queryList, Field.PresetField.GMT_CREATE.getId(), 1, pageNum, pageSize);
        return PageList.of(totalCount, pageSize, this.toItemList(result));
    }

    @Override
    public PageList<QueryTableItem<T>> pageQueryNoExt(Field queryType, Object value, Field sortField, QueryTable.SortType sortType, long pageNum, long pageSize) throws BizException {
        long totalCount;
        Field.PresetField presetField = sortField.getField();
        if (Objects.equals((Object)Field.PresetField.EXT1, (Object)presetField) || Objects.equals((Object)Field.PresetField.EXT2, (Object)presetField) || Objects.equals((Object)Field.PresetField.EXT3, (Object)presetField) || Objects.equals((Object)Field.PresetField.EXT4, (Object)presetField)) {
            throw new BizException("\u4e0d\u652f\u6301 EXT \u5b57\u6bb5\u6392\u5e8f");
        }
        if (Objects.equals((Object)Field.PresetField.DATA, (Object)presetField)) {
            throw new BizException("\u4e0d\u652f\u6301 DATA \u5b57\u6bb5\u6392\u5e8f");
        }
        List<PairDTO<Integer, Object>> queryList = Collections.emptyList();
        if (queryType != null) {
            queryList = Collections.singletonList(PairDTO.from(queryType.getField().getId(), value));
        }
        if ((totalCount = this.queryTableService.count(this.activityId, this.group, queryList)) == 0L) {
            return PageList.of(0L, pageSize, Collections.emptyList());
        }
        List<PlaywayQuerytableDTO> result = this.queryTableService.querySorted(this.activityId, this.group, queryList, sortField.getField().getId(), sortType == QueryTable.SortType.DESC ? 1 : 2, pageNum, pageSize);
        return PageList.of(totalCount, pageSize, this.toItemList(result));
    }

    private List<QueryTableItem<T>> toItemList(List<PlaywayQuerytableDTO> entities) {
        ArrayList<QueryTableItem<T>> list = new ArrayList<QueryTableItem<T>>(entities.size());
        for (PlaywayQuerytableDTO entity : entities) {
            list.add(new InnerItem(entity));
        }
        return list;
    }

    class InnerItem<T extends Field>
    implements QueryTableItem<T> {
        private PlaywayQuerytableDTO entity;

        public InnerItem(PlaywayQuerytableDTO entity) {
            this.entity = entity;
            entity.setGroupId(QueryTableImpl.this.group);
        }

        @Override
        public Object get(T field) {
            Field.PresetField presetField = field.getField();
            switch (presetField) {
                case ID: {
                    return this.entity.getId();
                }
                case SCORE: {
                    return this.entity.getScore();
                }
                case DATA: {
                    return this.entity.getStringData();
                }
                case EXT1: {
                    return this.entity.getExt1();
                }
                case EXT2: {
                    return this.entity.getExt2();
                }
                case EXT3: {
                    return this.entity.getExt3();
                }
                case EXT4: {
                    return this.entity.getExt4();
                }
                case GMT_CREATE: {
                    return this.entity.getGmtCreate();
                }
                case GMT_MODIFIED: {
                    return this.entity.getGmtModified();
                }
            }
            return null;
        }

        @Override
        public void set(T field, Object value) {
            Field.PresetField presetField = field.getField();
            switch (presetField) {
                case SCORE: {
                    this.entity.setScore(Long.valueOf(String.valueOf(value)));
                    break;
                }
                case DATA: {
                    this.entity.setStringData(String.valueOf(value));
                    break;
                }
                case EXT1: {
                    this.entity.setExt1(String.valueOf(value));
                    break;
                }
                case EXT2: {
                    this.entity.setExt2(String.valueOf(value));
                    break;
                }
                case EXT3: {
                    this.entity.setExt3(String.valueOf(value));
                    break;
                }
                case EXT4: {
                    this.entity.setExt4(String.valueOf(value));
                    break;
                }
                case GMT_CREATE: {
                    this.entity.setGmtCreate((Date)value);
                    break;
                }
                case GMT_MODIFIED: {
                    this.entity.setGmtModified((Date)value);
                }
            }
        }
    }
}

