package cn.com.duiba.cloud.duiba.activity.service.api.enums.sign;

import lombok.Getter;

/**
 * 签到周期类型
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/4/15
 */
@Getter
public enum SignPeriodTypeEnum {
    WHOLE(1, "全周期"),
    WEEK(2, "自然周"),
    MONTH(3, "自然月"),
    CUSTOM(4, "自定义周期"),

    ;
    private Integer code;
    private String msg;

    SignPeriodTypeEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    /**
     * 根据类型code查询
     */
    public static SignPeriodTypeEnum getByCode(Integer code){
        if(null == code){
            return null;
        }
        for(SignPeriodTypeEnum signPeriodTypeEnum: SignPeriodTypeEnum.values()){
            if(signPeriodTypeEnum.getCode().equals(code)){
                return signPeriodTypeEnum;
            }
        }
        return null;
    }

}
