package cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.sign;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author: 郑建豪
 * @date: 2022/5/12 11:57
 * @description: 签到奖励配置
 */
@Data
public class SignRewardVO implements Serializable {

    /**
     * 签到天数
     */
    @NotNull(message = "签到天数不能为空")
    private Integer signDays;

    /**
     * 是否有奖励
     * 0，无奖励；1，有奖励
     */
    @NotNull(message = "是否有奖励不能为空")
    private Integer hasReward;

    /**
     * 奖励的积分数
     */
    private Long rewardCredits;

    /**
     * 奖励的抽奖次数
     */
    private Integer rewardDrawTimes;

}
