package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.dto;


import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 积分玩法排行榜-配置表
*/
@Data
public class PlaywayLeaderboardArchiveDTO implements Serializable {

    private static final long serialVersionUID = -3591015764782950613L;
    /**
    * 主键
    */
    private Long id;

    /**
    * 项目id
    */
    private Long activityId;

    /**
    * 排行榜配置表id
    */
    private Long leaderboardId;

    /**
    * 排行榜名称（开始时间yyyyMMdd格式）
    */
    private String rankingType;

    /**
     * 排行榜名称-展示用（开始时间yyyyMMdd格式）+期
     */
    private String rankingName;

    /**
    * 排行榜期次顺序
    */
    private Integer leaderboardVersion;

    /**
    * 排行榜开始时间
    */
    private Date startTime;

    /**
     * 排行榜开始参与时间
     */
    private Date startJoinTime;

    /**
    * 结束时间
    */
    private Date endTime;

    /**
    * 开奖时间
    */
    private Date opTime;

    /**
    * 实际开奖时间（手动开奖时更新）
    */
    private Date actualOpTime;

    /**
    * 1-自动开奖 2手动开奖
    */
    private Integer opWay;

    /**
     * 开奖状态
     */
    private Integer opStatus;

    /**
     * 奖项json
     */
    private String optionJson;


}

