package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.enums;

import org.apache.commons.lang.StringUtils;

public enum RankKeyEnum {

    DEFAULT("default", "默认排行榜"),

    ;

    private String type;

    private String desc;

    RankKeyEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDefaultRank() {
        return DEFAULT.getType();
    }

    public static boolean isDefaultRank(String playwayId) {
        return StringUtils.equals(playwayId, getDefaultRank());
    }
}
