package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.dto.SignRecordDTO;

import java.util.Date;
import java.util.List;

/**
 * @author zhengjianhao
 * @date 2022/5/13
 * @description
 */
@AdvancedFeignClient
public interface RemoteSignApi {

	/**
	 * 查询用户今日签到记录
	 */
	SignRecordDTO getTodayRecord(Long activityId, Long userId) throws BizException;

	/**
	 * 查询用户今日是否已签到
	 */
	boolean checkTodaySign(Long activityId, Long userId) throws BizException;

	/**
	 * 查询用户在指定日期是否签到
	 */
	SignRecordDTO getRecordBySignDay(Long activityId, Long userId, Date signTime) throws BizException;

	/**
	 * 查询某个周期用户签到记录信息
	 */
	List<SignRecordDTO> getListByPeriod(Long activityId, Long userId, Date startTime, Date endTime) throws BizException;

	/**
	 * 签到
	 */
	Long sign(SignRecordDTO signRecordDTO) throws BizException;

	/**
	 * 查询补签次数
	 */
	int getComplementSignCount(Long activityId, Long userId, Date startTime, Date endTime) throws BizException;

	/**
	 * 根据签到记录id查询
	 */
	SignRecordDTO getById(Long id);
}
