package cn.com.duiba.cloud.duiba.activity.service.api.utils;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.concurrent.TimeUnit;

/**
 * 失效时间包装类
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: ExpireTime.java , v 0.1 2020-05-09 1:41 下午 ZhouFeng Exp $
 */
public class ExpireTime implements Serializable {

    private static final long serialVersionUID = -7375628288197522417L;

    private final Date expire;

    /**
     * 使用时间戳创建对象
     *
     * @param timestamp
     * @return
     */
    public static ExpireTime of(long timestamp) {
        return new ExpireTime(new Date(timestamp));
    }

    /**
     * 使用java.util.Date创建对象
     *
     * @param date
     * @return
     */
    public static ExpireTime of(Date date) {
        return new ExpireTime(date);
    }

    /**
     * 使用java.time.LocalDateTime创建对象
     *
     * @param dateTime
     * @return
     */
    public static ExpireTime of(LocalDateTime dateTime) {
        return new ExpireTime(Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant()));
    }

    /**
     * 使用失效时长创建对象
     *
     * @param timeout 失效时间
     * @param unit    单位
     * @return
     */
    public static ExpireTime duration(long timeout, TimeUnit unit) {
        return new ExpireTime(new Date(unit.toMillis(timeout) + System.currentTimeMillis()));
    }

    private ExpireTime(Date expire) {
        this.expire = expire;
    }

    public long getTimestamp() {
        return expire.getTime();
    }

    public Date getDate() {
        return expire;
    }

    public LocalDateTime getDateTime() {
        return expire.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }
}
