package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.MallActivityRulePrizeDTO;

import java.util.List;


/**
 * 活动奖品服务
 */
@AdvancedFeignClient
public interface RemoteActivityRulePrizeService {

    /**
     * 获取活动奖品
     * @param activityId
     * @return
     */
    List<MallActivityRulePrizeDTO> listByActivityId(Long activityId);

    /**
     * 批量保存
     * @param dtos
     * @return
     */
    Boolean saveBatch(List<MallActivityRulePrizeDTO> dtos);

    /**
     * 批量更新
     * @param dtos
     * @return
     */
    Boolean updateBatchById(List<MallActivityRulePrizeDTO> dtos);

    /**
     * 回退奖品库存
     * @param activityId  活动id
     * @param prizeIds 奖品ids
     * @return
     */
    @Deprecated
    Boolean rollbackStockByPrizeIds(Long activityId,List<Long> prizeIds) throws BizException;

    /**
     * 回退活动所有奖品库存
     * @param activityId
     * @return
     * @throws BizException
     */
    Boolean rollbackStockByActivityId(Long activityId) throws BizException;


    /**
     * 回退活动所有奖品待领取记录中的库存
     * @param activityId
     * @return
     * @throws BizException
     */
    Boolean rollbackRecordStockByActivityId(Long activityId) throws BizException;


    /**
     * getById
     * @param prizeId
     * @return
     */
    MallActivityRulePrizeDTO getById(Long prizeId);



    /**
     * getByIdList
     * @param prizeIds
     * @return
     */
    List<MallActivityRulePrizeDTO> getByIdList(List<Long> prizeIds);












}
