/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.biz.tool.exception;

import cn.com.duiba.cloud.biz.tool.exception.DuibaBizException;
import cn.com.duiba.cloud.biz.tool.message.Error;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class BizChecker {
    public static void checkNotNull(Object o, Error<String> code) throws DuibaBizException {
        if (o != null) {
            return;
        }
        BizChecker.throwException(code);
    }

    public static void checkIsTrue(boolean expression, Error<String> code) throws DuibaBizException {
        if (expression) {
            return;
        }
        BizChecker.throwException(code);
    }

    public static void checkNotBlank(String test, Error<String> code) throws DuibaBizException {
        if (StringUtils.isNotBlank((CharSequence)test)) {
            return;
        }
        BizChecker.throwException(code);
    }

    public static void checkGtZero(Number number, Error<String> code) throws DuibaBizException {
        if (number != null) {
            if (number instanceof Integer && (Integer)number > 0) {
                return;
            }
            if (number instanceof Long && (Long)number > 0L) {
                return;
            }
            if (number instanceof Float && ((Float)number).floatValue() > 0.0f) {
                return;
            }
            if (number instanceof Double && (Double)number > 0.0) {
                return;
            }
        }
        BizChecker.throwException(code);
    }

    public static void checkNotEmpty(Collection collection, Error<String> code) throws DuibaBizException {
        if (collection != null && collection.size() > 0) {
            return;
        }
        BizChecker.throwException(code);
    }

    public static void checkNotEmpty(Map map, Error<String> code) throws DuibaBizException {
        if (map != null && map.size() > 0) {
            return;
        }
        BizChecker.throwException(code);
    }

    public static void throwException(Error<String> code) throws DuibaBizException {
        throw new DuibaBizException(code.getMsg()).withCode(code.getCode());
    }

    public static void checkNotNull(Object o, String code) throws DuibaBizException {
        if (o != null) {
            return;
        }
        BizChecker.throwException(code);
    }

    public static void checkIsTrue(boolean expression, String code) throws DuibaBizException {
        if (expression) {
            return;
        }
        BizChecker.throwException(code);
    }

    public static void checkNotBlank(String test, String code) throws DuibaBizException {
        if (StringUtils.isNotBlank((CharSequence)test)) {
            return;
        }
        BizChecker.throwException(code);
    }

    public static void checkGtZero(Number number, String code) throws DuibaBizException {
        if (number != null) {
            if (number instanceof Integer && (Integer)number > 0) {
                return;
            }
            if (number instanceof Long && (Long)number > 0L) {
                return;
            }
            if (number instanceof Float && ((Float)number).floatValue() > 0.0f) {
                return;
            }
            if (number instanceof Double && (Double)number > 0.0) {
                return;
            }
        }
        BizChecker.throwException(code);
    }

    public static void checkNotEmpty(Collection collection, String code) throws DuibaBizException {
        if (collection != null && collection.size() > 0) {
            return;
        }
        BizChecker.throwException(code);
    }

    public static void checkNotEmpty(Map map, String code) throws DuibaBizException {
        if (map != null && map.size() > 0) {
            return;
        }
        BizChecker.throwException(code);
    }

    public static void throwException(String code) throws DuibaBizException {
        throw new DuibaBizException(code);
    }
}

