/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.biz.tool.message;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.biz.tool.message.Error;
import cn.com.duiba.cloud.biz.tool.message.ErrorFactory;
import java.util.Locale;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ErrorMeta
implements Error<String> {
    private String code;
    private String msg;
    private String isvModule;

    public ErrorMeta(String isvModule, String code, String msg) {
        Objects.requireNonNull(isvModule, "isvModule\u4e0d\u80fd\u4e3anull");
        Objects.requireNonNull(code, "code\u4e0d\u80fd\u4e3anull");
        Objects.requireNonNull(msg, "msg\u4e0d\u80fd\u4e3anull");
        this.isvModule = isvModule;
        this.code = code;
        this.msg = msg;
    }

    public ErrorMeta(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    @Override
    public String getMsg() {
        return this.msg;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public String getIsvModule() {
        return this.isvModule;
    }

    public BizException getException(Object ... params) {
        Locale locale;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
            locale = request.getLocale();
        } else {
            locale = Locale.SIMPLIFIED_CHINESE;
        }
        return this.getException(locale, params);
    }

    public BizException getException(Locale locale, Object ... params) {
        Error<String> error = ErrorFactory.getError(this, locale, params);
        return new BizException(error.getMsg()).withCode(error.getCode());
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setIsvModule(String isvModule) {
        this.isvModule = isvModule;
    }
}

